#
#
# global defaults
#
#
font create title_font -size 20

#
#
# Create a text widget with title displayed
#
#

proc make_title {widget title_string} {
text ${widget}.title -relief flat -foreground white -background black
${widget}.title insert end ${title_string} title
${widget}.title tag configure title -justify center -font title_font
${widget}.title configure -height 2 -width 50 -state disabled
}

#
#
# Displays about box
#
#

proc about_box {} {
toplevel .about 
frame .about.f -bd 4
text   .about.f.text -relief flat -background black -foreground green
.about.f.text insert end "Ps-i version 2.0 alpha" title
.about.f.text insert end "\n\t\t\tpreliminary version" warning
.about.f.text tag configure title -justify center -font title_font
.about.f.text configure -width 50 -height 4 -state disabled
button .about.f.ok -text "OK" -command { destroy .about }
pack .about.f .about.f.text .about.f.ok
update
}


#
#
# Asks user to choose attribute
#
#

proc close_choose_attribute {choice_var} {
global choose_attribute_var ${choice_var}
set ${choice_var} $choose_attribute_var
destroy .choose_attribute
}

proc new_choice_choose_attribute {} {
global choose_attribute_var
set i [find_attribute $choose_attribute_var]
if {$i<0} {
	return;
	} else {
	.choose_attribute.f.comment delete 0.0 end
	.choose_attribute.f.comment insert end $i
	}
}


proc choose_attribute {choice_var} {
global choose_attribute_var
toplevel .choose_attribute
frame .choose_attribute.f -bd 3
pack .choose_attribute.f

#
# Title
#

make_title .choose_attribute.f "Choose attribute:"
grid .choose_attribute.f.title - -sticky ew

#
# Main elements
#
combobox::combobox .choose_attribute.f.attr_list -height 7 -width 20 \
	-relief sunken -textvariable choose_attribute_var
frame .choose_attribute.f.misc_info -bd 0
grid .choose_attribute.f.attr_list .choose_attribute.f.misc_info -sticky news

text .choose_attribute.f.comment -relief sunken 
.choose_attribute.f.comment configure -width 50 -height 5
grid .choose_attribute.f.comment - -sticky ew

bind .choose_attribute.f.attr_list <<Combobox_change>> new_choice_choose_attribute

#
# control panel on the right
#

button .choose_attribute.f.misc_info.done -text "Apply" -command "close_choose_attribute ${choice_var}"
grid .choose_attribute.f.misc_info.done

set n [num_attributes]
for {set i 0} {$i < $n} {incr i} {
	.choose_attribute.f.attr_list listinsert end [attribute_name $i]
	}
}

#
#
#   Asks user to choose a field
#
#


proc close_choose_field {choice_var} {
global choose_field_var ${choice_var}
set ${choice_var} $choose_field_var
destroy .choose_field
}

proc new_choice_choose_field {} {
global choose_field_var
set i [find_field $choose_field_var]
if {$i<0} {
	return;
	} else {
	.choose_field.f.comment delete 0.0 end
	.choose_field.f.comment insert end $i
	}
}


proc choose_field {choice_var} {
global choose_field_var
toplevel .choose_field
frame .choose_field.f -bd 3
pack .choose_field.f

#
# Title
#

make_title .choose_field.f "Choose field:"
grid .choose_field.f.title - -sticky ew

#
# Main elements
#

combobox::combobox .choose_field.f.attr_list -height 7 -width 20 \
	-relief sunken -textvariable choose_field_var
frame .choose_field.f.misc_info -bd 0
grid .choose_field.f.attr_list .choose_field.f.misc_info -sticky news

text .choose_field.f.comment -relief sunken 
.choose_field.f.comment configure -width 50 -height 5
grid .choose_field.f.comment - -sticky ew

bind .choose_field.f.attr_list <<Combobox_change>> new_choice_choose_field

#
# control panel on the right
#

button .choose_field.f.misc_info.done -text "Apply" -command "close_choose_field ${choice_var}"
grid .choose_field.f.misc_info.done

set n [num_fields]
for {set i 0} {$i < $n} {incr i} {
	.choose_field.f.attr_list listinsert end [field_name $i]
	}
}

#
#
# Asks user to choose routine
#
#

proc close_choose_routine {choice_var} {
global choose_routine_var ${choice_var}
set ${choice_var} $choose_routine_var
destroy .choose_routine
}

proc new_choice_choose_routine {} {
global choose_routine_var
set i [find_routine $choose_routine_var]
if {$i<0} {
	return;
	} else {
	.choose_routine.f.comment configure -state normal
	.choose_routine.f.comment delete 0.0 end
	.choose_routine.f.comment insert end "Type:" type_title
	.choose_routine.f.comment insert end " [routine_type $i]\n\n" type_body
	.choose_routine.f.comment tag configure type_title  -foreground green
	.choose_routine.f.comment tag configure type_body  -foreground yellow
	.choose_routine.f.comment insert end "Description:" comment_title
	.choose_routine.f.comment insert end " [routine_comment $i]\n\n" comment_body
	.choose_routine.f.comment tag configure comment_title  -foreground green
	.choose_routine.f.comment tag configure comment_body  -foreground yellow
	.choose_routine.f.comment configure -state disabled
	}
}


proc choose_routine {choice_var} {
global choose_routine_var
if {[winfo exists .choose_routine]} {
	raise .choose_routine
	return
	}
toplevel .choose_routine
frame .choose_routine.f -bd 3
pack .choose_routine.f -fill both -expand  yes

#
# Title
#

make_title .choose_routine.f "Choose routine:"
grid .choose_routine.f.title - -sticky ew -pady 3

#
# Main elements
#
combobox::combobox .choose_routine.f.attr_list -height 7 -width 20 \
	-relief sunken -textvariable choose_routine_var
frame .choose_routine.f.misc_info -bd 0
grid .choose_routine.f.attr_list .choose_routine.f.misc_info -sticky news

text .choose_routine.f.comment -relief sunken  -background #505050 
.choose_routine.f.comment configure -width 60 -height 10 -wrap word -state disabled
grid .choose_routine.f.comment - -sticky news -pady 3
grid rowconfig .choose_routine.f 2 -weight 1
grid columnconfig .choose_routine.f 1 -weight 1
bind .choose_routine.f.attr_list <<Combobox_change>> new_choice_choose_routine

#
# control panel on the right
#
#      disabled for now
#
#button .choose_routine.f.misc_info.done -text "Apply" -command "close_choose_routine ${choice_var}"
#grid .choose_routine.f.misc_info.done
#

set n [num_routines]
for {set i 0} {$i < $n} {incr i} {
	.choose_routine.f.attr_list listinsert end [routine_name $i]
	}
}

#
#
# Agent view
#
#

global field_num agent_x agent_y
set field_num 0
set agent_x 0
set agent_y 0

proc update_agent_viewer1 {w x y} {
global field_num agent_x agent_y zoom$w
set field_num [find_field [$w.panel.field get]]
set zoom [set zoom$w]
set agent_x [expr round(([$w.f.display canvasx $x]*$zoom)/30-0.5)]
set agent_y [expr round(([$w.f.display canvasy $y]*$zoom)/30-0.5)]
update_agent_viewer
}

proc update_agent_viewer2 {a b c} {
update_agent_viewer
}

proc update_agent_viewer {} {
global field_num agent_x agent_y
set w .agent_view
if {![winfo exists $w]} {
	return
	}
$w.text configure -state normal
$w.text delete 0.0 end
if { $field_num < [num_fields]} {
	$w.text insert end "Field: " field_title
	$w.text insert end "[field_name $field_num]\n" field_body 
	$w.text tag configure field_title -foreground green
	$w.text tag configure field_body -foreground yellow
	}

$w.text insert end "X:" x_title
$w.text insert end "$agent_x " x_body
$w.text tag configure x_title -foreground green
$w.text tag configure x_body -foreground yellow
$w.text insert end "Y:" y_title
$w.text insert end "$agent_y\n" y_body
$w.text tag configure y_title -foreground green
$w.text tag configure y_body -foreground yellow
set N [num_attributes]
for {set i 0} {$i<$N} {incr i} {
	$w.text insert end "[attribute_name $i]:" attribute_title
	$w.text insert end "[agent_attr_value $field_num $agent_x $agent_y $i]\n" attribute_body
	$w.text tag configure attribute_title -foreground green
	$w.text tag configure attribute_body -foreground yellow
	}
$w.text configure -state disabled
}

proc new_agent_viewer {} {
global field_num,agent_x,agent_y
if {[winfo exists .agent_view]} {
	raise .agent_view
	return
	}
toplevel .agent_view
wm title .agent_view "Agent viewer"
set w .agent_view
text $w.text -width 20 -height 15 -background #505050
$w.text configure -state disabled -selectbackground black
grid $w.text -sticky news
grid rowconfig $w 0 -weight 1
grid columnconfig $w 0 -weight 1
update_agent_viewer
global time
trace variable time w update_agent_viewer2
}



#
#
# new_field_viewer - opens a new field viewer window
#
#

global fv_id
global time
global close_fv
set fv_id 0
set time [model_time]

proc new_field_viewer {} {
global fv_id
global time
global close_fv 

set w .field_viewer$fv_id

global zoom$w

toplevel $w
wm title $w "Field viewer"
set fv_id [expr $fv_id+1]

trace variable time w "update_field_viewer $w"
trace variable close_fv w "close_field_viewer $w"

frame $w.panel
pack $w.panel
button $w.panel.postscript -text "PostScript" -command "save_postscript $w"
combobox::combobox $w.panel.view -width 12 -textvariable fv_cv$w
combobox::combobox $w.panel.field -width 12 -textvariable fv_cf$w
button $w.panel.step -text {Step} -command "step_model1"
menubutton $w.panel.run -text "Run.." -menu .menu_run -relief raised
button $w.panel.runto -text {Run to..} -command "model_runto"
label $w.panel.time -text "Time: [model_time]" -background black -foreground white
menubutton $w.panel.zoom -menu $w.panel.zoom.menu -text "Zoom" -relief raised
menu $w.panel.zoom.menu -tearoff 0
$w.panel.zoom.menu add radiobutton -label {Close} \
	-command "update_field_viewer $w a b c" -variable zoom$w -value 1
$w.panel.zoom.menu add radiobutton -label {Normal} \
	-command "update_field_viewer $w a b c" -variable zoom$w -value 2
$w.panel.zoom.menu add radiobutton -label {Far} \
	-command "update_field_viewer $w a b c" -variable zoom$w -value 3
$w.panel.zoom.menu add radiobutton -label {Eagle} \
	-command "update_field_viewer $w a b c" -variable zoom$w -value 4
grid $w.panel.postscript $w.panel.view $w.panel.field $w.panel.zoom $w.panel.step $w.panel.runto $w.panel.time -sticky ns -padx 1

frame $w.f -bd 0
pack $w.f -expand yes -fill both
grid rowconfig $w 1 -weight 1
grid columnconfig $w 0 -weight 1
grid columnconfig $w 1 -weight 1
grid columnconfig $w 2 -weight 1
grid columnconfig $w 3 -weight 1
canvas $w.f.display -xscrollcommand "$w.f.hscroll set" \
	-yscrollcommand "$w.f.vscroll set" -relief sunken -bd 2 -background black
scrollbar $w.f.vscroll -command "$w.f.display yview"
scrollbar $w.f.hscroll -command "$w.f.display xview" -orient horiz
grid $w.f.display -sticky news;
grid $w.f.vscroll -row 0 -column 1 -sticky ns
grid $w.f.hscroll -row 1 -column 0 -sticky ew
grid rowconfig $w.f 0 -weight 1
grid columnconfig $w.f 0 -weight 1

#
# Put data inside
#

set n [num_fields]
for {set i 0 } {$i <$n} {incr i} {
	$w.panel.field listinsert end [field_name $i]
	}
if {$n >0 } {
	$w.panel.field insert end [field_name 0]
	}
	
set n [num_views]
for {set i 0 } {$i <$n} {incr i} {
	$w.panel.view listinsert end [view_name $i]
	}
if {$n >0 } {
	$w.panel.view insert end [view_name 0]
	}
bind $w.panel.view <<Combobox_change>> "update_field_viewer $w a b c"
bind $w.panel.field <<Combobox_change>> "update_field_viewer $w a b c"
set zoom$w 2
bind $w <Destroy> "close_field_viewer  $w a b c"
$w.f.display bind all <Motion> "update_agent_viewer1 $w %x %y"
update_field_viewer $w	a b c
}

global postscript_fn
set postscript_fn "view1.ps"

proc save_postscript w {
global postscript_fn
global zoom$w
set field_name [$w.panel.field get]
set field_index [find_field $field_name]
if { $field_index <0} {
	return;
	}
set zoom [set zoom$w]
set x_size [field_x_dim $field_index]
set y_size [field_y_dim $field_index]
set postscript_fn [ tk_getSaveFile -defaultextension {.ps} -initialfile $postscript_fn \
		-filetypes { {"Postscript" {.ps}} {"All Files" {.*}}}]
		
if {[catch { $w.f.display postscript -file $postscript_fn -x -2 -y -2  \
	-width [expr ($x_size *30)/$zoom+10] -height [expr ($y_size*30)/$zoom+10]}] \
	<0 } {
	show_status_error [ append a "Error writing postscript file " $postscript_fn ]
	return
	}
show_status_normal [ append a "Successfully wrote postscript file " $postscript_fn ]
return
}


proc update_field_viewer {w a b c} {
global time
global zoom$w
#
# get parameters
#

set field_name [$w.panel.field get]
set view_name [$w.panel.view get]
set field_index [find_field $field_name]
set view_index [find_view $view_name]
if { $field_index <0} {
	return;
	}
if { $view_index <0} {
	return;
	}
set zoom [set zoom$w]
set x_size [field_x_dim $field_index]
set y_size [field_y_dim $field_index]
$w.f.display configure -scrollregion "-10 -10 [expr ($x_size * 30)/$zoom +10] [expr ($y_size *30)/$zoom+10]"
$w.f.display delete all
for {set j 0} {$j < $y_size} {incr j} {
	for {set i 0} {$i < $x_size} {incr i} {
		set shape [view_shape $view_index $field_index $i $j]
		set color1 [view_color1 $view_index $field_index $i $j]
		set color2 [view_color2 $view_index $field_index $i $j]
		set color3 [view_color3 $view_index $field_index $i $j]
		draw_agent $w.f.display [expr ($i * 30)/$zoom] [expr ($j * 30)/$zoom] $zoom \
				$shape $color1 $color2 $color3
			
		}
	}
$w.panel.time configure -text "Time: $time"
}

proc close_field_viewer {w a b c} {
global time
global close_fv
trace vdelete time w "update_field_viewer $w"
trace vdelete close_fv w "update_field_viewer $w"
destroy $w
}

proc step_model1 {} {
global time
step_model
set time [model_time]
update
log_all_statistics
}

#
#
# Stuff that draws agents
#
#

#
#  First: close up view
#
#
# Bugs in here - 8.1 crashes when I try use llength.. Why ??? 
#
global agent_colors n_colors
set agent_colors { 
	 }
	 
#
# ************ Finish this
#	 
#	 
#foreach i {F 9 B 6} {
#	foreach j {F 9 B 6} {
#		foreach k {F 9 B 6} {
#			lappend agent_colors \#$i$j$k
#			}}}
##puts "[llength $agent_colors]"
#set n_colors [llength $agent_colors]
##set n_colors 6
#




#
#
# Generate palette
#
#


set hex_list {0 1 2 3 4 5 6 7 8 9 A B C D E F}
set color_list {}

set n_colors 20
set S 7
set PI 3.1415

#
#  vectors:  (1,1,1) - brightness
#   (1,1,-2) /sqrt(6)
#   (-1,1,0) /sqrt(2)
#

set s_2 [expr sqrt(2.0)]
set s_6 [expr sqrt(6.0)]
for {set I 11} {$I > 4} {incr I -3} {
for {set i 0} {$i<$n_colors} {incr i} {
	set H [expr (2*$PI*$i/$n_colors)]
	set alpha [expr sin($H)]
	set beta  [expr cos($H)]
	set r [expr round($I+$S*($alpha/$s_6-$beta/$s_2))]
	if {$r<0} {set r 0}
	if {$r>15} {set r 15}
	set g [expr round($I+$S*($alpha/$s_6+$beta/$s_2))]
	if {$g<0} {set g 0}
	if {$g>15} {set g 15}
	set b [expr round($I+$S*(-2*$alpha/$s_6))]
	if {$b<0} {set b 0}
	if {$b>15} {set b 15}
	set R [lindex $hex_list $r]
	set G [lindex $hex_list $g]
	set B [lindex $hex_list $b]
	lappend color_list \#$R$G$B
	} }

#set color_list [lsort -decreasing $color_list ]
set n_colors [llength $color_list]


#set n_colors 0
#foreach i $a { set n_colors [expr $n_colors+1] }

set agent_colors [lsort -decreasing $color_list ]
set n_colors [llength $color_list]

proc get_color color {
global agent_colors n_colors
set c [expr $color % $n_colors]
return [lindex $agent_colors $c]
}

#
#
#  display available colors
#
#

toplevel .color_palette
wm withdraw .color_palette
wm protocol .color_palette WM_DELETE_WINDOW { wm withdraw .color_palette }
text .color_palette.text -background black -width 50 -height 20 -wrap word
for {set i 0} {$i<$n_colors} {incr i} {
	set x [expr ($i % 10)*25+2]
	set y [expr ($i/10)*25+2]
	.color_palette.text insert end "\255$i\255" color_$i
	.color_palette.text tag configure color_$i -background [lindex $color_list $i] -foreground black 
	.color_palette.text insert end "\t"
	}
pack .color_palette.text -expand yes -fill both
#
#
#
#
#

proc draw_agent_square {canv x y zoom color1 color2} {
set x1 [expr $x]
set y1 [expr $y]
set x2 [expr $x+30/$zoom]
set y2 [expr ($y+30/$zoom)]
$canv create rectangle $x1 $y1 $x2 $y2 -fill [get_color $color1] 
set x1 [expr $x+10/$zoom]
set y1 [expr $y+10/$zoom]
set x2 [expr $x+20/$zoom]
set y2 [expr $y+20/$zoom]
$canv create rectangle $x1 $y1 $x2 $y2  -fill [get_color $color2] -outline black
}

proc draw_agent_square1 {canv x y zoom color1 color2} {
set x1 [expr $x+1]
set y1 [expr $y+1]
set x2 [expr $x+30/$zoom]
set y2 [expr ($y+30/$zoom)]
$canv create polygon $x1 $y1 $x1 $y2 $x2 $y2 $x2 $y1 -fill [get_color $color1] 
set x1 [expr $x+10/$zoom]
set y1 [expr $y+10/$zoom]
set x2 [expr $x+20/$zoom]
set y2 [expr $y+20/$zoom]
$canv create polygon $x1 $y1 $x1 $y2 $x2 $y2 $x2 $y1 -fill [get_color $color2] -outline black
}


proc draw_agent_pentagon {canv x y zoom color1 color2} {
set x1 [expr $x+15/$zoom+1]
set y1 [expr $y+1]
set x2 [expr ($x+30/$zoom)]
set y2 [expr $y+10/$zoom+1]
set x3 [expr $x+25/$zoom]
set y3 [expr ($y+30/$zoom)]
set x4 [expr $x+5/$zoom+1]
set y4 [expr ($y+30/$zoom)]
set x5 [expr $x+1]
set y5 [expr $y+10/$zoom+1]
$canv create polygon $x1 $y1 $x2 $y2 $x3 $y3 $x4 $y4 $x5 $y5 -fill [get_color $color1] 
set x1 [expr $x+10/$zoom]
set y1 [expr $y+12/$zoom]
set x2 [expr $x+20/$zoom]
set y2 [expr $y+22/$zoom]
$canv create rectangle $x1 $y1 $x2 $y2 -fill [get_color $color2] -outline black
}

proc draw_agent_oval {canv x y zoom color1 color2} {
set x1 [expr $x+1]
set y1 [expr $y+1]
set x2 [expr ($x+30/$zoom)]
set y2 [expr ($y+30/$zoom)]
$canv create oval $x1 $y1 $x2 $y2  -fill [get_color $color1] -outline black
set x1 [expr $x+10/$zoom]
set y1 [expr $y+10/$zoom]
set x2 [expr $x+20/$zoom]
set y2 [expr $y+20/$zoom]
$canv create polygon $x1 $y1 $x1 $y2 $x2 $y2 $x2 $y1 -fill [get_color $color2] -outline black
}

proc draw_agent_black {canv x y zoom color1 color2} {
set x1 [expr $x]
set y1 [expr $y]
set x2 [expr ($x+30/$zoom)]
set y2 [expr ($y+30/$zoom)]
$canv create rectangle $x1 $y1 $x2 $y2  -fill gray 
}

proc draw_agent_box {canv x y zoom color1 color2} {
set x1 [expr $x]
set y1 [expr $y]
set x2 [expr ($x+30/$zoom)]
set y2 [expr ($y+30/$zoom)]
$canv create rectangle $x1 $y1 $x2 $y2  -fill [get_color $color1]
}



proc draw_agent {canv x y zoom shape color1 color2 color3} {
if { $shape < 0} {
	draw_agent_black $canv $x $y $zoom $color1 $color2
	return
	}
switch [expr $shape % 4] \
	0 "draw_agent_box $canv $x $y $zoom $color1 $color2" \
	1 "draw_agent_square $canv $x $y $zoom $color1 $color2" \
	2 "draw_agent_pentagon $canv $x $y $zoom $color1 $color2" \
	3 "draw_agent_oval $canv $x $y $zoom $color1 $color2" 
}

#
#
# new_statistics_viewer - creates new statistics viewer window
#
#

toplevel .statistics 
wm withdraw .statistics
frame .statistics.panel
pack .statistics.panel  -fill x
frame .statistics.f
pack .statistics.f -expand yes -fill both

#
# prevent the user from accidently destroying the window
#

wm protocol .statistics WM_DELETE_WINDOW {wm withdraw .statistics}

#canvas .statistics.f.display -relief sunken -height 200 -width 320\
#	-xscrollcommand ".statistics.f.hscroll set" \
#	-yscrollcommand ".statistics.f.vscroll set" \
#	-scrollregion {0 0 200 100} -bd 2
text .statistics.f.display -relief sunken -height 15 -width 40\
	-xscrollcommand ".statistics.f.hscroll set" \
	-yscrollcommand ".statistics.f.vscroll set" \
	 -bd 2 -state disabled -wrap none
scrollbar .statistics.f.vscroll -command ".statistics.f.display yview"
scrollbar .statistics.f.hscroll -command ".statistics.f.display xview" -orient horiz

grid .statistics.f.display -sticky news
grid .statistics.f.vscroll -row 0 -column 1 -sticky ns
grid .statistics.f.hscroll -row 1 -column 0 -sticky ew
grid rowconfig .statistics.f 0 -weight 1
grid columnconfig .statistics.f 0 -weight 1

proc new_statistics_viewer {} {
if { [winfo exists .statistics] } {
	wm deiconify .statistics
	raise .statistics
	return
	}
wm deiconify .statistics
}

proc log_all_statistics1 {} {
.statistics.f.display delete all
catch { destroy .statistics.f.display.f}
frame .statistics.f.display.f 
.statistics.f.display create window 0 0 -window .statistics.f.display.f -anchor nw
set N [num_fields]
for { set i 0 } {$i <$N} {incr i} {
	log_statistics $i
	set M [num_stat]
	label .statistics.f.display.f.l0a${i}b -text "Field: \"[field_name $i]\"" -background black -foreground green
	grid .statistics.f.display.f.l0a${i}b - - - -column 0 \
				-row [expr 2*$i*($M+2)] -sticky news
	for {set j 0 } {$j < $M} {incr j} {
		set K [num_values $j]
		for {set l 0 } {$l<$K} {incr l} {
			if {$l % 2} {
				set color1 white
				set color2 blue
				} else {
				set color1 yellow
				set color2 black
				}
			label .statistics.f.display.f.l1a${i}b${j}c${l} -text [get_value_name $j $l] \
				-background blue -foreground $color1 -width 4
			grid .statistics.f.display.f.l1a${i}b${j}c${l} -column [expr $l+1] \
				-row [expr 2*$j+2*$i*($M+2)+1] -sticky news
			label .statistics.f.display.f.l3a${i}b${j}c${l} -text [get_value $j $l] \
				-background white -foreground $color2
			grid .statistics.f.display.f.l3a${i}b${j}c${l} -column [expr $l+1] \
				-row [expr 2*$j+2*$i*($M+2)+2] -sticky news
			}
		label .statistics.f.display.f.l2a${i}b${j}c -text [stat_name $j] -background white -foreground red
		grid .statistics.f.display.f.l2a${i}b${j}c -column 0 \
				-row [expr 2*$j+2*$i*($M+2)+2] -sticky news
		
		}
	}
.statistics.f.display configure -scrollregion \
	"0 0 [winfo width .statistics.f.display.f] [winfo height .statistics.f.display.f]"

}

proc log_all_statistics {} {
.statistics.f.display configure -state normal
.statistics.f.display delete 0.0 end
set N [num_fields]
for { set i 0 } {$i <$N} {incr i} {
	log_statistics $i
	set M [num_stat]
	.statistics.f.display  insert end "Field: \"[field_name $i]\"" field_$i
	.statistics.f.display tag configure field_$i -background black -foreground green
	.statistics.f.display insert end "\n"
	for {set j 0 } {$j < $M} {incr j} {
		.statistics.f.display insert end "[stat_name $j]\n" stat_name_$j
		.statistics.f.display tag configure stat_name_$j -background white -foreground red
		set K [num_values $j]
		for {set l 0 } {$l<$K} {incr l} {
			.statistics.f.display insert end "[get_value_name $j $l]\t" tag_name_${j}_${l}
			}
		.statistics.f.display insert end "\n"
		for {set l 0 } {$l<$K} {incr l} {
			.statistics.f.display insert end "[get_value $j $l]\t" tag_value_${j}_$l
			}
		.statistics.f.display insert end "\n"
		for {set l 0 } {$l<$K} {incr l} {
			if {$l % 2} {
				set color1 white
				set color2 blue
				} else {
				set color1 yellow
				set color2 black
				}
			.statistics.f.display tag configure tag_value_${j}_$l -background white -foreground $color2
			.statistics.f.display tag configure tag_name_${j}_$l -background blue -foreground $color1 
			}
		.statistics.f.display insert end "\n"
		}
	}
.statistics.f.display configure -state disabled
}

#
# Submit model - loads the contents of the buffer into the engine
#
#

proc submit_model {} {
global close_fv run_go
global time
set buffer "[.f.model get 0.0 end ]"
if { $run_go } {toggle_run }
#
# close old file viewer windows
#

set close_fv 1
catch { destroy .choose_routine }
#
# reset model
#

reset_model
set time 0

#
# load code
#

set success [yyparse_string "$buffer"]

#
# Check whether we got an error
#

if { $success < 0 } {
	set line [get_line_of_error]
	set char [get_char_of_error]
	.f.model see ${line}.${char}
	.f.model tag add sel ${line}.0 ${line}.${char}
	set message [get_message_of_error]
	show_status_error $message
	return
	}
show_status_success "Data accepted with no problems."
seed_fields
log_all_statistics
}

#
#
# Runto - batch processing
#
#

proc model_runto {} {
global time
toplevel .runto
label .runto.l0 -text "Step until:"
entry .runto.value 
.runto.value insert end "$time"
button .runto.go -text "Go!" -command model_runto_go
grid .runto.l0 .runto.value -sticky news
grid .runto.go - -sticky news
grab set .runto
}

proc model_runto_go {} {
global time

set dest_time [.runto.value get]
grab release .runto
destroy .runto

if {$dest_time <= $time} {
	return
	}
toplevel .runto_progress
global runto_go
set runto_go 1
bind .runto_progress <Destroy> {global runto_go ; set runto_go 0
	 set time [model_time] 
	 grab release .runto_progress }
grab set .runto_progress
label .runto_progress.l0 -text "Computation in progress..."
scale .runto_progress.scale -orient horiz -from $time -to $dest_time
pack .runto_progress.l0
pack .runto_progress.scale
for {set i $time} {($i < $dest_time) && $runto_go} {incr i} {
	if { $runto_go} {step_model;log_all_statistics; .runto_progress.scale set $i }
	update
	}
if {$runto_go } {	
.runto_progress.l0 configure -text "Updating windows..."
update
set time [model_time]
grab release .runto_progress
destroy .runto_progress
}
}

#
#
# Model input-output
#
#

global fn
set fn "test1.mdl"

proc save_model1 {} {
global fn
set fn [tk_getSaveFile -defaultextension {.mdl} -initialfile $fn \
	 -filetypes { {"Ps-i model" {.mdl}} {"All Files" {.*}}}]
if {[catch {	 
	set fileid [open $fn w]
	set model_data [.f.model get 0.0 end]
	puts $fileid $model_data
	close $fileid }]<0 } {
	show_status_error [append a "Error saving to file " $fn]
	return
	}
show_status_normal [append a "Successfully saved buffer to file " $fn]	
}

proc load_model1 {} {
global fn 
set fn [tk_getOpenFile -defaultextension {.mdl} \
	-filetypes { {"Ps-i model" { .mdl } } {"All files" { .* } } }]
if {[winfo exists .ac_editor]} {
	destroy .ac_editor
	}
if {[ catch {	set fileid [open $fn r]	} ]<0 } {
	show_status_error "Open failed";
	return; 
	}

set model_data [read $fileid]
close $fileid
.f.model delete 0.0 end
.f.model insert end $model_data
show_status_normal [append a "Successfully loaded " $fn]
}

#
#
# This controls the nice status line in the bottom
#
#

proc show_status_normal a {
.f.status insert end "\n"
.f.status insert end $a normal
.f.status tag configure normal -foreground yellow
.f.status see end
}

proc show_status_success a {
.f.status insert end "\n"
.f.status insert end $a success
.f.status tag configure success -foreground green
.f.status see end
}

proc show_status_error a {
.f.status insert end "\n"
.f.status insert end $a error
.f.status tag configure error -foreground red
.f.status see end

#
# Let's be annoying :)
#

bell
}

#
#
#
#
#

proc reseed_model {} {
global time
if { [catch { seed_fields } ]<0} {
	show_status_error "Could not reseed fields"
	set time [model_time]
	update
	return
	}
show_status_normal "Fields reseeded"
update
set time [model_time]
log_all_statistics
}

#
#
# run
#
#


global run_go
set run_go 0

proc toggle_run {} {
global run_go
switch [.run_b cget -text] \
	"Run"	{.run_b configure -text "Stop" ; \
		if {! $run_go} {set run_go 1 ; model_run} } \
	"Stop"  {.run_b configure -text "Run" ; set run_go 0 }

}

proc model_run {} {
global run_go
if {$run_go} {
	step_model1
	after 50 model_run
	}
}
	
#
#
#  Main window routines
#
#

frame .f -bd 0
pack .f -expand yes -fill both

#
# Menu
#

menu .menu
menu .menu.file -tearoff false
menu .menu.view -tearoff true
menu .menu.help -tearoff false
menu .menu.options -tearoff false
menu .menu.options.wrap -tearoff false
. configure -menu .menu

.menu add cascade -label {File} -menu .menu.file
.menu add cascade -label {View} -menu .menu.view
.menu add cascade -label {Options} -menu .menu.options
.menu add cascade -label {Help} -menu .menu.help


.menu.help add command -label {About} -command about_box
.menu.help add command -label {Routine browser} -command {choose_routine a}
.menu.help add command -label {Color palette} -command {wm deiconify .color_palette}

.menu.file add command -label {Load model} -command load_model1
.menu.file add command -label {Save model} -command save_model1
.menu.file add separator
.menu.file add command -label {Exit} -command exit

.menu.view add command -label {New field viewer} -command {new_field_viewer}
.menu.view add command -label {New statistics viewer} -command {new_statistics_viewer}
.menu.view add command -label {New agent viewer} -command {new_agent_viewer}

.menu.options add cascade -label {Wrap} -menu .menu.options.wrap
.menu.options.wrap add radiobutton -label {None} -command {.f.model configure -wrap none}
.menu.options.wrap add radiobutton -label {Character} -command {.f.model configure -wrap char}
.menu.options.wrap add radiobutton -label {Word} -command {.f.model configure -wrap word}

text .f.model -relief sunken -wrap none -xscrollcommand ".f.hscroll set" \
	-yscrollcommand ".f.vscroll set" -takefocus 1
.f.model configure -width 80 -height 30

scrollbar .f.vscroll -command ".f.model yview"
scrollbar .f.hscroll -command ".f.model xview" -orient horiz
scrollbar .f.vscroll1 -command ".f.status yview" 

grid .f.model  -sticky news
grid .f.vscroll -row 0 -column 1 -sticky ns
grid .f.hscroll  -row 1 -column 0 -sticky ew
grid rowconfig .f 0 -weight 1
grid columnconfig .f 0 -weight 1
text .f.status -relief flat -background black -yscrollcommand ".f.vscroll1 set"

.f.status configure -width 80 -height 3 -takefocus 0
grid .f.status -row 2 -column 0 -sticky ew
grid .f.vscroll1 -row 2 -column 1 -sticky ns

button .submit -text "Submit" -command "submit_model" -activebackground red
button .reseed -text "Reseed" -command "reseed_model" -activebackground red
button .runto_b -text {Run to..} -command "model_runto"
button .run_b -text {Run} -command "toggle_run"
label .time_l -text "Time: $time" -background black -foreground white

proc update_time_l {a b c} {
global time
.time_l configure -text "Time: $time"
}
trace variable time w update_time_l

pack .submit .reseed .runto_b .run_b .time_l -side left -padx 1 -fill y

#
#
# Initial sequence of commands
#
#

update
load_model1
